(function() {
	var defaultSkin = {
		id: 0,
		folder: '../theme0',
		color: '105,153,251',
		type: 'light'
	}

	var curSkin = $.extend(true, {}, defaultSkin);
	
	function hexToRGB(hexStr) {
		var bigint = parseInt(hexStr, 16);
		var r = (bigint >> 16) & 255;
		var g = (bigint >> 8) & 255;
		var b = bigint & 255;
		return [r, g, b].join(',');
	}

	function setCurSkin(id, color, type) {
		curSkin.id = id;
		curSkin.folder = '../theme' + id;
		curSkin.color = color;
		curSkin.type = type;
		//console.log(curSkin)
	}

	function onChangeSkin(str) {
		//console.log(str)
		var obj = JSON.parse(str);
		setCurSkin(obj['SkinID'], hexToRGB(obj['SkinColor']), obj['SkinType']);
		$QGContainer.trigger('change_skin');
	}

	window.Skin = {
		curSkin: curSkin,
		defaultSkin: defaultSkin,
		onChangeSkin: onChangeSkin,
		onResponseSkin: function (str) {
			var rsp = JSON.parse(str);
			str = rsp.skin;
			onChangeSkin(str);
		}
	}
})();